PROCEDURE Parse_Name IS
  -- Parse the name, Check for Vulgar words, and update the gender
  -- NOTE: This procedure should be fired on WHEN-VALIDATE-ITEM on the name field
  name  								 CLEAN_Address.Name_Rec;
  fv_return_code         VARCHAR2(10);
  fv_return_description  VARCHAR2(500);
BEGIN
  -- Only Verify if the trigger item is the same as the cursor item
  -- (ie. don't fire more than once for one update)
  if :system.trigger_item != :system.cursor_item then
    return;
  end if;

  -- Parse the name, Check for Vulgar words, and update the gender
  -- Leave if we don't have enough data
  if :ADDR.address_name IS NULL then
	   return;
  end if;
  
  -- initialize the input name
  name.full_name := :ADDR.address_name;
  
  -- parse the name
 	CLEAN_Address.Name_Parse_Silent(
                       name
                      ,fv_return_code
                      ,fv_return_description
                      );
  if fv_return_code IS NOT NULL then
    WARNING(fv_return_description);
    return;
  end if;

  -- Set the output fields
  :ADDR.address_name := name.full_name;
  :ADDR.name_prefix  := name.name_prefix;
  :ADDR.first_name   := name.first_name;
  :ADDR.middle_name  := name.middle_name;
  :ADDR.last_name    := name.last_name;
  :ADDR.name_suffix  := name.name_suffix;
  
  -- Only set the gender if it's not already set
  if name.gender IS NOT NULL then
    :ADDR.gender_code := name.gender;
  end if;
  
  -- Set the status code
  :ADDR.name_status_code := NULL;
  if name.name_parse_status_code IS NOT NULL then
    :ADDR.name_status_code := name.name_parse_status_code||'-'||cln$lookup.get_name_status(name.name_parse_status_code);
  end if;
  
 	if name.name_parse_status_code = 'V' then
 		WARNING('WARNING: Vulgar word found in name!');
 	end if;
 	
  set_item_property('ADDR.ADDRESS_NAME',   ITEM_IS_VALID, PROPERTY_TRUE);	

END;
